/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.iterators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class IteratorChain
implements Iterator {
    protected final List iteratorChain = new ArrayList();
    protected int currentIteratorIndex = 0;
    protected Iterator currentIterator = null;
    protected Iterator lastUsedIterator = null;
    protected boolean isLocked = false;

    public int size() {
        return this.iteratorChain.size();
    }

    public IteratorChain() {
    }

    private void checkChainIntegrity() {
        if (this.iteratorChain.size() == 0) {
            throw new UnsupportedOperationException("IteratorChains must contain at least one Iterator");
        }
    }

    private void checkLocked() {
        if (this.isLocked) {
            throw new UnsupportedOperationException("IteratorChain cannot be changed after the first use of a method from the Iterator interface");
        }
    }

    private void lockChain() {
        if (!this.isLocked) {
            this.checkChainIntegrity();
            this.isLocked = true;
        }
    }

    public void remove() throws UnsupportedOperationException, IllegalStateException {
        this.lockChain();
        this.updateCurrentIterator();
        this.lastUsedIterator.remove();
    }

    /*
     * Unable to fully structure code
     */
    protected void updateCurrentIterator() {
        if (this.currentIterator == null) {
            this.lastUsedIterator = this.currentIterator = (Iterator)this.iteratorChain.get(0);
            return;
        }
        if (this.currentIteratorIndex != this.iteratorChain.size() - 1) ** GOTO lbl10
        return;
lbl-1000:
        // 1 sources

        {
            ++this.currentIteratorIndex;
            this.currentIterator = (Iterator)this.iteratorChain.get(this.currentIteratorIndex);
            if (this.currentIteratorIndex != this.iteratorChain.size() - 1) continue;
            return;
lbl10:
            // 2 sources

            ** while (!this.currentIterator.hasNext())
        }
lbl11:
        // 1 sources

    }

    public boolean hasNext() throws UnsupportedOperationException {
        this.lockChain();
        this.updateCurrentIterator();
        this.lastUsedIterator = this.currentIterator;
        return this.currentIterator.hasNext();
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public Object next() throws NoSuchElementException, UnsupportedOperationException {
        this.lockChain();
        this.updateCurrentIterator();
        this.lastUsedIterator = this.currentIterator;
        return this.currentIterator.next();
    }

    public IteratorChain(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Iterator iterator2 = (Iterator)iterator.next();
            this.addIterator(iterator2);
        }
    }

    public void setIterator(int n, Iterator iterator) throws IndexOutOfBoundsException {
        this.checkLocked();
        if (iterator == null) {
            throw new NullPointerException("Iterator must not be null");
        }
        this.iteratorChain.set(n, iterator);
    }

    public IteratorChain(Iterator iterator) {
        this.addIterator(iterator);
    }

    public void addIterator(Iterator iterator) {
        this.checkLocked();
        if (iterator == null) {
            throw new NullPointerException("Iterator must not be null");
        }
        this.iteratorChain.add(iterator);
    }

    public IteratorChain(Iterator[] iteratorArray) {
        int n = 0;
        while (n < iteratorArray.length) {
            this.addIterator(iteratorArray[n]);
            ++n;
        }
    }

    public List getIterators() {
        return Collections.unmodifiableList(this.iteratorChain);
    }

    public IteratorChain(Iterator iterator, Iterator iterator2) {
        this.addIterator(iterator);
        this.addIterator(iterator2);
    }
}

